//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Security;
using System.Security.Permissions;
using System.Collections;
using System.Diagnostics;

namespace CLRUnleashed
{
	/// <summary>
	/// Podsumowanie dla DayPermissionTest.
	/// </summary>
	class DayPermissionTest
	{
		private static void DailyAccess()
		{
			DayPermission perm = new DayPermission(DayOfWeek.Wednesday);
			perm.Demand();
		}

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			PermissionSet ps = new PermissionSet(PermissionState.None);
			DayPermission perm = new DayPermission(DayOfWeek.Wednesday);
			ps.AddPermission(perm);
			ps.PermitOnly();
			DailyAccess();
			ArrayList days = new ArrayList();
			days.Add(DayOfWeek.Monday);
			days.Add(DayOfWeek.Tuesday);
			days.Add(DayOfWeek.Wednesday);
			days.Add(DayOfWeek.Thursday);
			days.Add(DayOfWeek.Friday);
			DayPermission dp = new DayPermission(days);
			string dpXML = dp.ToXml().ToString();
			Debug.WriteLine(dpXML);
		}
	}
}
